library(memisc)
library(munfold)

# source("~/R/devel/memisc/trunk/munfold/R/Unfold.R")
# cmp3 <- read.csv("cmp3.csv")
load("cmp3.RData")
source("unfold-cmp-func.R")

cmp3 <- subset(cmp3,country < 70)

unfold.econ <- cmp.unfold(
  free.enterprise +
  economic.orthodoxy +
  incentives +
  market.regulation +
  economic.planning +
  controlled.economy +
  nationalise ~ econdim,# + z1,
    data=cmp3
)

# unfold.econ <- procrustes(unfold.econ,
#                     target = list(
#                       free.enterprise = c(1,0),
#                       incentives = .5,
#                       economic.orthodoxy = 1,
#                       market.regulation  = -1,
#                       economic.planning  = -1,
#                       controlled.economy = -1,
#                       nationalise = -1
#                       ),
#                     translate=TRUE,
#                     dilate=FALSE
#                   )


unfold.econ <- relabel(unfold.econ,
  free.enterprise =    "Free enterprise",
  economic.orthodoxy = "Economic orthodoxy",
  incentives =         "Incentives",
  market.regulation =  "Market regulation",
  economic.planning =  "Economic planning",
  controlled.economy = "Controlled economy",
  nationalise =        "Nationalisation"
  )

plot(unfold.econ)

unfold.nonmat <- cmp.unfold(
              law.order +
              national.way.pos +
              national.way.neg +
              traditional.morality.pos +
              traditional.morality.neg +
              #freedom +
              democracy #+
              #pol.authority +
              #social.harmony
              ~ authlib + tradmod + z3 + z4 + z5 + z6,
    data=cmp3
)

unfold.nonmat$B



unfold.nonmat <- procrustes(unfold.nonmat,
                    target = list(
                        national.way.pos         = c( 1, 0, 0),
                        national.way.neg         = c(-1, 0,0),
                        traditional.morality.pos = c( 0, 1,0),
                        traditional.morality.neg = c( 0,-1),
                        law.order                = c( 1, 0),
                        #freedom                  = c(-1, 0, 0),
                        democracy                = c(-1, 0)#,
                        #pol.authority            = c( 1, 0),
                        #social.harmony           = c( 0.5, 0.5, 1)
                      ),
                    translate=TRUE,
                    dilate=FALSE
                  )

biplot(unfold.nonmat)

unfold.nonmat <- relabel(unfold.nonmat,
                  national.way.pos = "National way of life pos.",
                  national.way.neg = "National way of life neg.",
                  traditional.morality.pos = "Traditional morality pos.",
                  traditional.morality.neg = "Traditional morality neg.",
                  law.order = "Law and order",
                  democracy = "Democracy"
                  )

unfold.nonmat$B


unfold.authlib <- cmp.unfold(
              national.way.pos +
              #national.way.neg +
              law.order +
              freedom +
              democracy #+
              #pol.authority #+
              #social.harmony
              ~ authlib ,#+ z2 + z3 + z4 + z5 + z6,
    data=cmp3
)

unfold.authlib$B



# unfold.authlib <- procrustes(unfold.authlib,
#                     target = list(
#                         national.way.pos         = c( 1, 0, 0),
#                         national.way.neg         = c(-1, 0,0),
#                         law.order                = c( 1, 0),
#                         freedom                  = c(-1, 0, 0),
#                         democracy                = c(-1, 0),
#                         pol.authority            = c( 1, 0)#,
#                         #social.harmony           = c( 0.5, 0.5, 1)
#                       ),
#                     translate=TRUE,
#                     dilate=FALSE
#                   )

# biplot(unfold.authlib)

plot(unfold.authlib)

unfold.authlib$B


unfold.tradmod <- cmp.unfold(
              traditional.morality.pos +
              traditional.morality.neg #+
              #noneconomic.groups
              ~ tradmod,# + z2,
    data=cmp3
)

unfold.tradmod$B



unfold.tradmod <- procrustes(unfold.tradmod,
                    target = list(
                        traditional.morality.pos = c( 1),
                        traditional.morality.neg = c( -1)
                      ),
                    translate=TRUE,
                    dilate=FALSE
                  )

plot(unfold.tradmod)

unfold.tradmod$B

cmp.unfolded <- within(cmp3,{
  econdim <- unfold.econ$A[,"econdim"]
  authlib <- unfold.nonmat$A[,"authlib"]
  tradmod <- unfold.nonmat$A[,"tradmod"]
})

save(unfold.econ,unfold.nonmat,unfold.authlib,unfold.tradmod,
    file="cmp-unfolding-solutions.RData")
save(cmp.unfolded,file="cmp-unfolded.RData")

biplot(unfold.nonmat)

writeLines(toLatex(unfold.econ$B,digits=2),con="econ-lr-table.tex")
writeLines(toLatex(unfold.nonmat$B[,1:2],digits=2),con="nonmat-table.tex")
